/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.network;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.INetworkPacket;
import dev.toma.gunsrpg.network.packet.C2S_AmmoBenchEventPacket;
import dev.toma.gunsrpg.network.packet.C2S_ChangeFiremodePacket;
import dev.toma.gunsrpg.network.packet.C2S_FusePacket;
import dev.toma.gunsrpg.network.packet.C2S_PacketSetJamming;
import dev.toma.gunsrpg.network.packet.C2S_PlaySoundFromAnimationEventPacket;
import dev.toma.gunsrpg.network.packet.C2S_PurifyPacket;
import dev.toma.gunsrpg.network.packet.C2S_QuestActionPacket;
import dev.toma.gunsrpg.network.packet.C2S_RequestBatteryChange;
import dev.toma.gunsrpg.network.packet.C2S_RequestDataUpdatePacket;
import dev.toma.gunsrpg.network.packet.C2S_RequestExtensionSkillLockPacket;
import dev.toma.gunsrpg.network.packet.C2S_RequestRepairPacket;
import dev.toma.gunsrpg.network.packet.C2S_RequestSkilledCraftPacket;
import dev.toma.gunsrpg.network.packet.C2S_RequestStashDetectorStatus;
import dev.toma.gunsrpg.network.packet.C2S_SelectAmmoPacket;
import dev.toma.gunsrpg.network.packet.C2S_SetAimingPacket;
import dev.toma.gunsrpg.network.packet.C2S_SetReloadingPacket;
import dev.toma.gunsrpg.network.packet.C2S_ShootPacket;
import dev.toma.gunsrpg.network.packet.C2S_SkillClickedPacket;
import dev.toma.gunsrpg.network.packet.C2S_TurretSettingsPacket;
import dev.toma.gunsrpg.network.packet.C2S_UnlockSkillPacket;
import dev.toma.gunsrpg.network.packet.S2C_AnimationPacket;
import dev.toma.gunsrpg.network.packet.S2C_NewSkillsPacket;
import dev.toma.gunsrpg.network.packet.S2C_OpenQuestScreen;
import dev.toma.gunsrpg.network.packet.S2C_SendEntityData;
import dev.toma.gunsrpg.network.packet.S2C_SetTrackedStashPacket;
import dev.toma.gunsrpg.network.packet.S2C_SynchBlockEntityPacket;
import dev.toma.gunsrpg.network.packet.S2C_SynchronizationPayloadPacket;
import dev.toma.gunsrpg.network.packet.S2C_UpdateCapabilityPacket;
import dev.toma.gunsrpg.network.packet.S2C_UseStashDetectorPacket;
import java.util.function.Predicate;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class NetworkManager {
    public static final Marker MARKER = MarkerManager.getMarker((String)"Networking");
    private static final String VERSION = "v15";
    private static final SimpleChannel CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)GunsRPG.makeResource("network")).networkProtocolVersion(() -> "v15").clientAcceptedVersions("v15"::equals).serverAcceptedVersions("v15"::equals).simpleChannel();
    private static byte ID;

    public static void sendServerPacket(INetworkPacket<?> packet) {
        CHANNEL.sendToServer(packet);
    }

    public static void sendWorldPacket(World world, INetworkPacket<?> packet) {
        NetworkManager.sendWorldPacket(world, packet, player -> true);
    }

    public static void sendWorldPacket(World world, INetworkPacket<?> packet, Predicate<ServerPlayerEntity> condition) {
        if (!(world instanceof ServerWorld)) {
            throw new UnsupportedOperationException("Cannot send world packet from client!");
        }
        world.func_217369_A().stream().map(pl -> (ServerPlayerEntity)pl).filter(condition).forEach(serverPlayerEntity -> NetworkManager.sendClientPacket(serverPlayerEntity, packet));
    }

    public static void sendToAllTracking(Entity entity, INetworkPacket<?> packet) {
        CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), packet);
    }

    public static void sendClientPacket(ServerPlayerEntity user, INetworkPacket<?> packet) {
        CHANNEL.sendTo(packet, user.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static void init() {
        NetworkManager.registerNetworkPacket(S2C_UpdateCapabilityPacket.class);
        NetworkManager.registerNetworkPacket(S2C_AnimationPacket.class);
        NetworkManager.registerNetworkPacket(S2C_NewSkillsPacket.class);
        NetworkManager.registerNetworkPacket(S2C_SynchBlockEntityPacket.class);
        NetworkManager.registerNetworkPacket(S2C_SynchronizationPayloadPacket.class);
        NetworkManager.registerNetworkPacket(S2C_SetTrackedStashPacket.class);
        NetworkManager.registerNetworkPacket(S2C_UseStashDetectorPacket.class);
        NetworkManager.registerNetworkPacket(S2C_OpenQuestScreen.class);
        NetworkManager.registerNetworkPacket(S2C_SendEntityData.class);
        NetworkManager.registerNetworkPacket(C2S_ShootPacket.class);
        NetworkManager.registerNetworkPacket(C2S_RequestDataUpdatePacket.class);
        NetworkManager.registerNetworkPacket(C2S_SelectAmmoPacket.class);
        NetworkManager.registerNetworkPacket(C2S_SetAimingPacket.class);
        NetworkManager.registerNetworkPacket(C2S_SetReloadingPacket.class);
        NetworkManager.registerNetworkPacket(C2S_ChangeFiremodePacket.class);
        NetworkManager.registerNetworkPacket(C2S_UnlockSkillPacket.class);
        NetworkManager.registerNetworkPacket(C2S_RequestSkilledCraftPacket.class);
        NetworkManager.registerNetworkPacket(C2S_SkillClickedPacket.class);
        NetworkManager.registerNetworkPacket(C2S_PacketSetJamming.class);
        NetworkManager.registerNetworkPacket(C2S_RequestRepairPacket.class);
        NetworkManager.registerNetworkPacket(C2S_RequestBatteryChange.class);
        NetworkManager.registerNetworkPacket(C2S_RequestStashDetectorStatus.class);
        NetworkManager.registerNetworkPacket(C2S_FusePacket.class);
        NetworkManager.registerNetworkPacket(C2S_PurifyPacket.class);
        NetworkManager.registerNetworkPacket(C2S_RequestExtensionSkillLockPacket.class);
        NetworkManager.registerNetworkPacket(C2S_QuestActionPacket.class);
        NetworkManager.registerNetworkPacket(C2S_TurretSettingsPacket.class);
        NetworkManager.registerNetworkPacket(C2S_PlaySoundFromAnimationEventPacket.class);
        NetworkManager.registerNetworkPacket(C2S_AmmoBenchEventPacket.class);
    }

    private static <P extends INetworkPacket<P>> void registerNetworkPacket(Class<P> packetType) {
        INetworkPacket packet;
        try {
            packet = (INetworkPacket)packetType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ReportedException(CrashReport.func_85055_a((Throwable)e, (String)"Couldn't instantiate packet for registration. Make sure you have provided public constructor with no parameters."));
        }
        byte by = ID;
        ID = (byte)(by + 1);
        CHANNEL.registerMessage((int)by, packetType, INetworkPacket::encode, packet::decode, INetworkPacket::handle);
    }
}

